#version 330
#extension GL_EXT_gpu_shader4 : enable
// Sacred GeometryMod01.fsh by  gleurop

//https://www.shadertoy.com/view/Xs23WK
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels


#define iTime u_Elapsed  //*0.314159  //*0.1666
#define iResolution u_WindowSize


//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

#define ITERS 8
#define SCALE 2.0
#define SPEED 0.25;

vec3 hsv(float h,float s,float v) {
	return mix(vec3(1.),clamp((abs(fract(h+vec3(3.,2.,1.)/3.)*6.-3.)-1.),0.,1.),s)*v;
}

float col(vec2 p, float t) {
	float a = length(p)-p.x;
	float b = max(abs(p.x-1.0),abs(p.y-1.0));
	float c = max(p.x, p.y);
	float d = b*a;
	return t*0.1 + mix(mix(a, b, sin(t*2.31)*0.5+0.5), mix(c, d, sin(t+1.0)*0.5+0.5), sin(t*0.46)*0.5+0.5);
}
void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord ) 
{
	float aspect = iResolution.x/iResolution.y;
	vec2 p = (-1.0+2.0*gl_FragCoord.xy / iResolution.xy);
	p.x *= aspect;
	p += 1.0;
	vec3 c = vec3(0);
	float t = 5.0+iTime*SPEED;
	for (int j = 0; j < ITERS; j++) {
		p = abs(p-1.0);
		float h = col(p, t);
		c += hsv(sin(h*4.0)*0.5+0.5, 1.0, 1.0);
		p *= SCALE;
	}
	gl_FragColor = vec4(cos(c*0.3+0.4)*0.5+0.5, 1.0);
}